//
//  MCSelectionCenter.h
//  MCApplication
//
//  Created by aj on Wed Sep 26 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *MCSelectionDidChangeNotification;
extern NSString *MCSetSelectedObjectNotification;


@interface MCSelectionCenter : NSObject {

    NSMutableSet	*selectionSet;


}

+ (id)defaultCenter;

//
// sets the currently selected object, unselects all
// previously selected objects
- (void)setSelectedObject:(id)anObject;

//get this when listen to MCSetSelectedObjectNotification notification
- (void)setSelectedObjectFromNotification:(NSNotification *)notif;

//
// Adds to the bottom of the array of selected objects
// but does not unselected previously selected objects
- (void)addToSelectedObjects:(id)anObject;

//
// Unselects previously selected objects by sending -(void)unselect
// to the object and removing them from the selectedObjects array
- (void)unselectedAllObjects;

//
//
- (void)removeFromSelectedObjects:(id)anObject;

//
// Returns the array of selected objects
- (NSArray *)selectedObjects;

//
// Returns the currently selected object or the first object
// in the selectedObjects array
- (id)selectedObject;


@end


@interface NSObject (MCSelection)

//
// unregisters with the selection center and calls unselectWithoutRegistering
- (void)unselect;

//
// does the unselection work -- default implementation does nothing - subclass responsibility
- (void)unselectWithoutRegistering;

//
// registers with the selection center and then calls selectWithoutRegistering
- (void)select;

//
// adds the receiver to the selection center then call selectWithoutRegistering
- (void)selectUsingModifier:(int)aMod;

//
// does the actual selection work (i.e. change color) - default implementation does nothing - subclass responsibility
- (void)selectWithoutRegistering;
@end

